/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.fcs.impl.disc;

import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.impl.disc.DiscoveryPlugin;
import com.ibm.hwmca.fw.fcs.impl.disc.PollableDiscoveryPlugin;
import com.ibm.hwmca.fw.fcs.impl.stream.FcsControlClient;
import com.ibm.hwmca.fw.util.NamedTimer;
import com.ibm.hwmca.fw.util.Trace;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;

public class DiscoveryCenter {
    private static final String TRACE_MASKD = "XFCSDISD";
    private static final String TRACE_MASKF = "XFCSDISF";
    private static final String TRACE_MASKT = "XFCSDIST";
    private Map discoveryPlugins = new HashMap();
    private static DiscoveryCenter _singleton;
    private static Object singletonLock;
    public static DiscoveryPlugin fcsInternallyDiscovered;
    private static NamedTimer pollingTimer;

    private DiscoveryCenter() {
        this.discoveryPlugins.put(fcsInternallyDiscovered, new HashSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized DiscoveryCenter getDiscoveryCenter() {
        Object object = singletonLock;
        synchronized (object) {
            if (_singleton == null) {
                _singleton = new DiscoveryCenter();
                _singleton.init();
            }
        }
        return _singleton;
    }

    private void init() {
        Set pluginClasses = FcsServer.getFcsServer().getConfigManager().getDiscoveryPlugins();
        Iterator iterator = pluginClasses.iterator();
        while (iterator.hasNext()) {
            String className = (String)iterator.next();
            try {
                Class<?> cl = Class.forName(className);
                DiscoveryPlugin plugin = (DiscoveryPlugin)cl.newInstance();
                Trace.trace(TRACE_MASKF, "Instantiated plugin: " + className);
                this.discoveryPlugins.put(plugin, new HashSet());
                if (!(plugin instanceof Runnable)) continue;
                Thread pluginThread = new Thread((Runnable)((Object)plugin), "FCS Discovery Plugin - " + className);
                pluginThread.start();
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "Error using '" + className + "' as a FCS discovery plugin: " + e.getMessage());
            }
        }
        pollingTimer = new NamedTimer("FCS Discovery Polling timer");
        pollingTimer.schedule((TimerTask)new PollingTask(), FcsServer.getFcsServer().getConfigManager().getMachineSearchTime() * 1000, (long)(FcsServer.getFcsServer().getConfigManager().getMachineSearchTime() * 1000));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void poll() {
        DiscoveryPlugin plugin;
        Iterator<Object> iterator;
        HashSet<DiscoveryPlugin> plugins = new HashSet<DiscoveryPlugin>();
        Object object = singletonLock;
        synchronized (object) {
            iterator = this.discoveryPlugins.keySet().iterator();
            while (iterator.hasNext()) {
                plugin = (DiscoveryPlugin)iterator.next();
                if (!(plugin instanceof PollableDiscoveryPlugin)) continue;
                plugins.add(plugin);
            }
        }
        Set unclaimedAddys = (Set)this.discoveryPlugins.get(fcsInternallyDiscovered);
        iterator = plugins.iterator();
        while (iterator.hasNext()) {
            plugin = (PollableDiscoveryPlugin)iterator.next();
            Set addys = (Set)this.discoveryPlugins.get(plugin);
            InetAddress[] addresses = null;
            try {
                addresses = plugin.getAvailableAddresses();
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "Error polling plugin: " + plugin);
                Trace.trace(TRACE_MASKF, e);
            }
            if (addresses == null) continue;
            addys.clear();
            for (int i = 0; i < addresses.length; ++i) {
                if (addresses[i] == null) continue;
                if (FcsServer.getFcsServer().getMachineId(addresses[i]) == null) {
                    FcsControlClient fcc = new FcsControlClient(addresses[i], "FcsControlCommandDataExchange");
                    Thread t = new Thread((Runnable)fcc, "FCS discovery exchange to " + addresses[i]);
                    t.start();
                }
                if (addys != null) {
                    Trace.trace(TRACE_MASKF, "Adding [" + addresses[i] + "] on behalf of " + plugin);
                    addys.add(addresses[i]);
                }
                unclaimedAddys.remove(addresses[i]);
            }
        }
    }

    public void foundAddress(InetAddress address, DiscoveryPlugin plugin) {
        this.foundAddresses(new InetAddress[]{address}, plugin);
    }

    public void foundAddresses(InetAddress[] addresses, DiscoveryPlugin plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException("Plugin may not be null");
        }
        if (addresses == null) {
            throw new IllegalArgumentException("Addresses may not be null");
        }
        Set addys = (Set)this.discoveryPlugins.get(plugin);
        Set unclaimedAddys = (Set)this.discoveryPlugins.get(fcsInternallyDiscovered);
        for (int i = 0; i < addresses.length; ++i) {
            if (addresses[i] == null) continue;
            if (FcsServer.getFcsServer().getMachineId(addresses[i]) == null) {
                FcsControlClient fcc = new FcsControlClient(addresses[i], "FcsControlCommandDataExchange");
                Thread t = new Thread((Runnable)fcc, "FCS discovery exchange to " + addresses[i]);
                t.start();
                Trace.trace(TRACE_MASKF, "Adding [" + addresses[i] + "] on behalf of " + plugin);
            }
            if (addys != null) {
                addys.add(addresses[i]);
            }
            unclaimedAddys.remove(addresses[i]);
        }
    }

    public void removeAddress(InetAddress address, DiscoveryPlugin plugin) {
        this.removeAddresses(new InetAddress[]{address}, plugin);
    }

    public void removeAddresses(InetAddress[] addresses, DiscoveryPlugin plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException("Plugin may not be null");
        }
        if (addresses == null) {
            throw new IllegalArgumentException("Addresses may not be null");
        }
        Set addys = (Set)this.discoveryPlugins.get(plugin);
        for (int i = 0; i < addresses.length; ++i) {
            if (addresses[i] == null || addys == null) continue;
            Trace.trace(TRACE_MASKF, "Removing [" + addresses[i] + "] on behalf of " + plugin);
            addys.remove(addresses[i]);
            FcsControlClient fcc = new FcsControlClient(addresses[i], "FcsControlCommandDataExchange");
            Thread t = new Thread((Runnable)fcc, "FCS verification exchange to " + addresses[i]);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getKnownAddressesByPlugin(String pluginClassName) {
        try {
            DiscoveryPlugin pluginObject = null;
            Class<?> cl = Class.forName(pluginClassName);
            Object object = singletonLock;
            synchronized (object) {
                Iterator iterator = this.discoveryPlugins.keySet().iterator();
                while (iterator.hasNext()) {
                    DiscoveryPlugin plugin = (DiscoveryPlugin)iterator.next();
                    if (!plugin.getClass().getName().equals(pluginClassName)) continue;
                    pluginObject = plugin;
                }
            }
            if (pluginObject != null) {
                return this.getKnownAddressesByPlugin(pluginObject);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Set getKnownAddressesByPlugin(DiscoveryPlugin plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException("Plugin may not be null");
        }
        Set addys = (Set)this.discoveryPlugins.get(plugin);
        Set returnAddys = (Set)((HashSet)addys).clone();
        return returnAddys;
    }

    public void registerPlugin(DiscoveryPlugin plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException("Plugin may not be null");
        }
        this.discoveryPlugins.put(plugin, new HashSet());
    }

    public void unregisterPlugin(DiscoveryPlugin plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException("Plugin may not be null");
        }
        this.discoveryPlugins.remove(plugin);
    }

    static {
        singletonLock = new Object();
        fcsInternallyDiscovered = new DiscoveryPlugin(){};
    }

    class PollingTask
    extends TimerTask {
        PollingTask() {
        }

        public void run() {
            Trace.trace(DiscoveryCenter.TRACE_MASKF, " PollingTask pops, calling poll().");
            DiscoveryCenter.getDiscoveryCenter().poll();
        }

        public boolean cancel() {
            Trace.trace(DiscoveryCenter.TRACE_MASKF, " PollingTask canceled.");
            return super.cancel();
        }

        public void schedule(int delay) {
            Trace.trace(DiscoveryCenter.TRACE_MASKF, " PollingTask scheduling timer pop " + delay + "ms in future.");
            pollingTimer.schedule((TimerTask)this, delay);
        }
    }
}

